<#ibiztemplate>
TARGET=PSDEDBTABLE
</#ibiztemplate>
package ${pub.getPKGCodeName()}.mybatis.${de.getPSSystemModule().getCodeName()?lower_case};

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Collection;
import java.io.Serializable;
import java.lang.reflect.Field;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONArray;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import ${pub.getPKGCodeName()}.core.repository.${de.getCodeName()}Repository;
<#if de.getPSDERInherit()??>
  <#if de.getPSDERInherit().getMajorPSDataEntity()??>
import ${pub.getPKGCodeName()}.core.repository.${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()}Repository;
  </#if>
</#if>
import ${pub.getPKGCodeName()}.core.repository.po.${de.getCodeName()};
import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.filter.${de.codeName}SearchContext;
import ${pub.getPKGCodeName()}.mybatis.${de.getPSSystemModule().getCodeName()?lower_case}.mapper.${item.name}Mapper;
import ${pub.getPKGCodeName()}.mybatis.${de.getPSSystemModule().getCodeName()?lower_case}.po.${item.name}Impl;
import ${pub.getPKGCodeName()}.mybatis.util.helper.QueryBuilder;
import ${pub.getPKGCodeName()}.mybatis.util.helper.DEHelper;

/**
 * 关系型数据实体表[${item.name}]存储对象
 */
@Slf4j
@Repository
@ConditionalOnProperty(prefix = "${de.getCodeName()?lower_case}", value="store" , havingValue = "sql", matchIfMissing = <#if de.getStorageMode()==1>true<#else>false</#if>)
public class ${item.name}RepositoryImpl extends ServiceImpl<${item.name}Mapper, ${item.name}Impl> implements ${de.getCodeName()}Repository {

    private Log logger= LogFactory.getLog(${item.name}RepositoryImpl.class);

    <#if de.getPSDERInherit()??>
      <#if de.getPSDERInherit().getMajorPSDataEntity()??>
    @Autowired
    ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()}Repository ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository ;
      </#if>
    </#if>

    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [${item.name}]持久层映射对象
     */
    @Autowired
	${item.name}Mapper ${item.name?uncap_first}Mapper;

    /**
     * 实体辅助对象
     */
    @Autowired
    DEHelper deHelper;

    /**
     * 创建持久层对象
     * @return
     */
    public ${de.getCodeName()} createPO(){
        return new ${item.name}Impl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public ${de.getCodeName()} get(String key){
        return this.getById(key);
    }

    <#--private boolean isLogicValid = ${de.isLogicValid()?c} ;-->
    <#--  public ${item.name} get(${item.name} po){
        ${item.name} result = this.get(po.get${de.getKeyPSDEField().getCodeName()?lower_case?cap_first}());
        if(result!=null){
		    BeanCopier copier=BeanCopier.create(result.getClass(),po.getClass(), false);
		    copier.copy(result,po,null);
    	}
    	return po;
    }  -->
    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(${de.getCodeName()} po){
        boolean bOk = this.save((${item.name}Impl)po);
        <#if de.getPSDERInherit()??>
          <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        ${pub.getPKGCodeName()}.core.repository.po.${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()} ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first} = convert2Inherit(po) ;
        ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository.create(${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}) ;
          </#if>
        </#if>
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(${de.getCodeName()} po){
        boolean bOk = this.updateById((${item.name}Impl)po);
        <#if de.getPSDERInherit()??>
          <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        ${pub.getPKGCodeName()}.core.repository.po.${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()} ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first} = convert2Inherit(po) ;
        ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository.update(${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}) ;
          </#if>
        </#if>
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        <#if de.getPSDERInherit()??>
          <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository.remove(key) ;
          </#if>
        </#if>
        return this.removeById(key);
    }

    /**
     * 批量新建
     * @param entityList 需要新建的数据集合
     * @param batchSize 每次新建数量
     * @return
     */
    public void createBatch(List entityList, int batchSize) {
          this.saveBatch(entityList,batchSize);
    }

    /**
     * 批量更新
     * @param entityList 需要更新的数据集合
     * @param batchSize 每次更新数量
     * @return
     */
    public void updateBatch(List entityList, int batchSize) {
          this.updateBatchById(entityList,batchSize);
    }

    /**
     * 批量删除
     * @param idList 需要删除的数据主键集合
     * @return
     */
    public void removeBatch(Collection<? extends Serializable> idList) {
          this.removeByIds(idList);
    }

    /**
     * 批量建立数据，忽略建立数据过程中出现的错误
     * @param entityList 批量建立的数据集合
     * @return 建立过程中出现错误的数据主键集合
     */
    public JSONArray createBatchIgnoreErrors(Collection entityList) {

        Field keyField=null;
        JSONArray errorList = new JSONArray();
        Iterator it=entityList.iterator();
        while(it.hasNext()){
            Object obj = it.next();
            if(ObjectUtils.isEmpty(keyField)){
                keyField=deHelper.getKeyField(obj);
            }
            try {
                boolean isSuccess=this.create((${item.name}Impl) obj);
                if(!isSuccess){
                    setErrorList(errorList,obj,keyField,"");
                }
            } catch (Exception e) {
                setErrorList(errorList,obj,keyField,e.getMessage());
            }
        }
        return errorList;
    }

    /**
     * 批量更新数据，忽略更新数据过程中出现的错误
     * @param entityList 批量更新的数据集合
     * @return 更新过程中出现错误的数据主键集合
     */
    public JSONArray updateBatchIgnoreErrors(Collection entityList) {

        Field keyField=null;
        JSONArray errorList = new JSONArray();
        Iterator it=entityList.iterator();
        while(it.hasNext()){
            Object obj = it.next();
            if(ObjectUtils.isEmpty(keyField)){
                keyField=deHelper.getKeyField(obj);
            }
            try {
                boolean isSuccess=this.update((${item.name}Impl) obj);
                if(!isSuccess){
                    setErrorList(errorList,obj,keyField,"");
                }
            } catch (Exception e) {
                    setErrorList(errorList,obj,keyField,e.getMessage());
            }
        }
        return errorList;
    }

    /**
     * 批量删除数据，忽略删除数据过程中出现的错误
     * @param idList 批量删除的数据主键集合
     * @return 删除过程中出现错误的数据主键集合
     */
    public JSONArray removeBatchIgnoreErrors(Collection<? extends Serializable> idList) {

        JSONArray errorList = new JSONArray();
        Iterator it=idList.iterator();
        while(it.hasNext()){
            Object id = it.next();
            try {
                boolean isSuccess=this.remove((String)id);
                if(!isSuccess){
                    errorList.add(id);
                    logger.error(String.format("批量删除[%s]发生错误，出错的数据[%s]，错误原因[%s]","${item.name}",id,""));
                }
            } catch (Exception e) {
                errorList.add(id);
                logger.error(String.format("批量删除[%s]发生错误，出错的数据[%s]，错误原因[%s]","${item.name}",id,e));
            }
        }
        return errorList;
    }

    /**
     * 设置错误信息
     * @param errorList
     * @param obj
     * @param keyField
     * @param errorInfo
     */
    private void setErrorList(JSONArray errorList,Object obj, Field keyField,String errorInfo){

        Object keyFieldValue=deHelper.getKeyFieldValue(obj,keyField);
        if(!ObjectUtils.isEmpty(keyFieldValue)){
            errorList.add(keyFieldValue);
        }
        logger.error(String.format("操作[%s]发生错误，出错的数据[%s]，错误原因[%s]","${item.name}",keyFieldValue,errorInfo));
    }

    /**
     * 通过条件更新数据
     * @param po 更新数据内容
     * @param context 更新条件
     * @return
     */
    public boolean updateByCond(${de.getCodeName()} po, ${de.getCodeName()}SearchContext context) {
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        return this.update((${item.name}Impl) po,qw);
    }

    /**
     * 通过条件删除数据
     * @param context 更新条件
     * @return
     */
    public boolean removeByCond(${de.getCodeName()}SearchContext context) {
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        return this.remove(qw);
    }

<#if de.getAllPSDEDataSets()??>
    <#list de.getAllPSDEDataSets() as dedataset>
    /**
     * 查询集合[${dedataset.getCodeName()}]
     * @param context 查询上下文对象
     * @return
     */
    public Page<${de.getCodeName()}> search${dedataset.getCodeName()?cap_first}(${de.codeName}SearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<${de.getCodeName()}> page_datas=${item.name?uncap_first}Mapper.search${dedataset.getCodeName()?cap_first}(page,context,qw);
        List<${de.getCodeName()}> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<${de.getCodeName()}>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    </#list>
</#if>
    <#if de.getPSDERInherit()??>
      <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        <#assign parentDE = de.getPSDERInherit().getMajorPSDataEntity()>
        <#assign indexKeyField = parentDE.getIndexTypePSDEField()>
        <#assign parentDEKeyField = parentDE.getKeyPSDEField()>
        <#assign parentDENameField = parentDE.getPSDEField(parentDE.getName()+"NAME") >
        <#assign childDEKeyField = de.getKeyPSDEField()>
        <#assign childDENameField = de.getPSDEField(de.getName()+"NAME") >
    /**
     * 转业务继承主对象
     * @param po 持久层对象
     * @return
     */
    public ${pub.getPKGCodeName()}.core.repository.po.${parentDE.getCodeName()} convert2Inherit(${de.getCodeName()} po){
        if(po == null)
            return null ;
        ${pub.getPKGCodeName()}.core.repository.po.${parentDE.getCodeName()} ${parentDE.getCodeName()?uncap_first} = ${parentDE.getCodeName()?uncap_first}Repository.createPO() ;
        ${parentDE.getCodeName()?uncap_first}.set${indexKeyField.getCodeName()?cap_first}("${de.getPSDERInherit().getTypeValue()}") ;
        ${parentDE.getCodeName()?uncap_first}.set${parentDEKeyField.getCodeName()?cap_first}(po.get${childDEKeyField.getCodeName()?cap_first}()) ;
        ${parentDE.getCodeName()?uncap_first}.set${parentDENameField.getCodeName()?cap_first}(po.get${childDENameField.getCodeName()?cap_first}()) ;
        <#list parentDE.getAllPSDEFields()  as defield>
        <#if (defield.getName() != parentDEKeyField.getName()) && (defield.getName() != parentDENameField.getName())&& (defield.getName() != indexKeyField.getName())>
        if(po.get${defield.getCodeName()?cap_first}DirtyFlag())
            ${parentDE.getCodeName()?uncap_first}.set${defield.getCodeName()?cap_first}(po.get${defield.getCodeName()?cap_first}());
        </#if>
        </#list>
        return ${parentDE.getCodeName()?uncap_first} ;
    }

      </#if>
    </#if>
    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} convert2Domain( ${de.getCodeName()} po ,${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()}();
        }
    <#list de.getAllPSDEFields()  as defield>
        //if(po.get${defield.getCodeName()?cap_first}DirtyFlag())
        domain.set${defield.getCodeName()?cap_first}(po.get${defield.getCodeName()?cap_first}());
    </#list>
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public ${de.getCodeName()} convert2PO(${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} domain , ${de.getCodeName()} po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
    <#list de.getAllPSDEFields()  as defield>
        if(domain.get${defield.getCodeName()?cap_first}DirtyFlag())
            po.set${defield.getCodeName()?cap_first}(domain.get${defield.getCodeName()?cap_first}());
    </#list>

        return po ;
    }
}
